#include <amxmodx>
#include <amxmisc>
#include <respawn>
#include <kz>

enum
{
	userid = 0,
	name
};

enum
{
	NotStarted = 1,
	Started,
	Finish
};

enum
{
	button = 0,
	reset,
	spawn
}

// Pointer Cvar
new kz_enabled;

// Prizes Commnads
#define MAXCOMMANDS 25

new count;
new commands[MAXCOMMANDS][50];
new type[MAXCOMMANDS] = { -1, ... };
new when[MAXCOMMANDS] = { -1, ... };
new on[MAXCOMMANDS] = { -1, ...};


public plugin_init()
{
	register_plugin("KZ Prizes", KZ_VERSION, "teame06");
	kz_enabled = get_cvar_pointer("kz_enabled");
}

public kz_Init(_state)
{
	if(!_state)
	{
		pause("a");
		return;
	}

	if(!get_pcvar_num(kz_enabled))
		return;

	new prizes[64];
	get_configsdir(prizes, 63);
	formatex(prizes, 63, "%s/kz/prizes.ini", prizes);

	// File Read.
	new infp = fopen(prizes, "rt"); // Open File

	if(!infp)
	{
		log_amx("[kz] Can't open prize files");
		return;
	}

	new data[64]; // Temp
	new temp[3]; // NotStarted? Started? Finish?
	new temp1[3]; // Spawn? Start/Finish button? Reset?
	new temp2[10]; // Type

	while(!feof(infp) && count < MAXCOMMANDS)
	{
		fgets(infp, data, 63 );

		if(data[0] == ';' || data[0] == '^n' || data[0] == '#' || data[0] == '/' || data[0] == '\')
			continue;

		// when on "commands" type
		parse(data, temp, 3, temp1, 3, commands[count], 49, temp2, 9);

		switch(temp[0]) // Error checking
		{
			case 'a':
				on[count] = button;
			case 'b':
				on[count] = reset;
			case 'c':
				on[count] = spawn;
			default:
			{
				log_amx("[kz] Invalid When Type %s. Valid type are 'a' Start, 'b' Finish, 'c' Spawn", temp);
				continue;
			}
		}

		switch(temp1[0]) // Error checking
		{
			case '1':
				when[count] = NotStarted;
			case '2':
				when[count] = Started;
			case '3':
				when[count] = Finish;
			default:
			{
				log_amx("[kz] Invalid When Type %s. Valid type are '1' NotStarted, '2' Started, '3' Finish", temp1[0]);
				continue;
			}
		}

		if(equali(temp2, "userid", 5)) // Error checking
			type[count] = userid;
		else if(equali(temp2, "name", 4))
			type[count] = name;
		else
		{
			log_amx("[kz] Invalid prize type %s. Valid type ^"userid^", ^"name^"", temp2);
			continue;	// Invalid type.
		}

		if(containi("%s", commands[count]) != -1) // Error checking
		{
			if(type[count] == userid)
			{
				log_amx("[kz] Invalid server command usage %s. Using %s with 'userid' type is invalid. You must use the type 'name'", "%s", commands[count]);
				continue;
			}
		}
		else if(containi("%d", commands[count]) != -1) // Error checking
		{
			if(type[count] == name)
			{
				log_amx("[kz] Invalid server command usage %s. Using %d with 'name' type is invalid. You must use type 'userid'", "%d", commands[count]);
				continue;
			}
		}
		count++;
	}
	fclose(infp); // Close file
}

public PostSpawn(player)
{
	find_cmd(player, spawn);
}

public kz_StartClimb(player)
{
	find_cmd(player, button);
}

public kz_FinishClimb(player, time, cp_count, gc_count)
{
	// Set God Mode.
	set_pev(player, pev_takedamage, 0.0);

	find_cmd(player, button);
}

public kz_ResetClimb(player)
{
	find_cmd(player, reset);
}

find_cmd(player, _type)
{
	new i;
	while(i < count)
	{
		if(on[i] == _type)
		{
			switch(when[i])
			{
				case NotStarted:
				{
					if(!IsPlayerStarted(player))
					{
						server_command(player, commands[i], type[i]);
					}
				}
				case Started:
				{
					if(IsPlayerStarted(player))
					{
						server_command(player, commands[i], type[i]);
					}
				}
				case Finish:
				{
					if(IsPlayerFinished(player))
					{
						server_command(player, commands[i], type[i]);
					}
				}
			}
		}
		i++;
	}
}

server_command(id, command[], type)
{
	switch(type)
	{
		case userid:
		{
			server_cmd(command, get_user_userid(id));
		}
		case name:
		{
			static _name[32];
			get_user_name(id, _name, 31);
			server_cmd(command, _name);
		}
	}
}