/* AMX Mod script. 
*
* AMX Public Restart Round Vote v1.0 (public_rr_vote)
*
* This file is provided as is (no warranties)
*
* Usage
* -----
*	- open file addons\amx\admin.cfg
*	- add these lines to admin.cfg :
*		amx_voterr_delay 60
* 		amx_voterr_time 10
* 		amx_voterr_ratio 0.60
*	- save the changes to file admin.cfg :)
*
* CVARs
* -----
* 	amx_voterr_delay -> minimum delay in seconds between two voting sessions (default 60 sec)
* 	amx_voterr_time  -> how long voting session goes on (default 10 sec)
* 	amx_voterr_ratio -> ratio for voting success (default 0.60)
*
* You can customize the CVARs for your need of course.
*
* To do:
*	- command 'amx_voterr_enable' which admins can use to enable or disable public voting
*	- maybe more public say commands
* 
*/ 

#include <amxmod>
#include <amxmisc>
 
new bool:cstrike
new votefor = 0
new Float:vote_ratio

public restart_round(time[])
{
	server_cmd("sv_restartround %s",time)
	return PLUGIN_CONTINUE
}

public delay_msg() {
	set_hudmessage(0, 255, 255, -1.0, 0.35, 1, 2.0, 6.0, 0.8, 0.8, 1)
	show_hudmessage(0,"- GO GO GO -")
	return PLUGIN_CONTINUE
}

public check_votes() { 
	new players[32],inum
	get_players(players,inum,"c")
	new Float:voteresult = inum ? (float(votefor) / float(inum)) : 0.0
	if (voteresult<vote_ratio){
		client_print(0,print_chat,"* RESa HebyDeT! (ZA ^"%d^") (PROTIV ^"%d^") (NUGNO ^"%.2f^" procentov).",votefor,inum-votefor,vote_ratio)
		return PLUGIN_HANDLED
	}
	set_task(2.0,"restart_round",0,"1",1)
	set_task(4.0,"restart_round",0,"1",1)
	set_task(6.0,"restart_round",0,"3",1)
	set_task(12.0,"delay_msg")
	client_print(0,print_chat,"* Bolwenstvo za RES! (ZA ^"%.2f^" Procentov) (PROTIV ^"%.2f^") (Nugno bulo ^"%.2f^").",voteresult,inum-votefor,vote_ratio)
	client_print(0,print_chat,"* Restarting round 3 times...")
	return PLUGIN_HANDLED
} 

public count_votes(id,key){
	new name[32] 
	get_user_name(id,name,31)
	client_print(0,print_chat,"* %s golosoval %s RES.",name,key ? "Protiv" : "Za")
	if (!key) ++votefor
	return PLUGIN_HANDLED 
} 

public voterr(id,level,cid) { 
	new Float:voting = get_cvar_float("amx_last_voting")
	if (voting > get_gametime()){ 
		client_print(id,print_chat,"* Golosovanie yge zapyweno ...") 
		return PLUGIN_HANDLED 
	} 
	if (voting && voting + get_cvar_float("amx_voterr_delay") > get_gametime()) { 
		client_print(id,print_chat,"* Golosovanie nekotoroe vremia NEDOSTUPNO...") 
		return PLUGIN_HANDLED 
	} 
	new msg[256]
	new keys = (1<<0)|(1<<1)
	if(cstrike)
		format(msg,255,"\yRestart round?\w^n^n1.  Yes^n2.  No")
	else
		format(msg,255,"Restart round?^n^n1.  Yes^n2.  No")
	new Float:vote_time = get_cvar_float("amx_voterr_time") + 2.0 
	set_cvar_float("amx_last_voting", get_gametime() + vote_time)
	vote_ratio = get_cvar_float("amx_voterr_ratio") 
	show_menu(0,keys,msg,floatround(vote_time)) 
	set_task(vote_time,"check_votes")
	client_print(id,print_chat,"* ZAPUWENO GOLOSOVANIE za Restart round...")
	votefor = 0
	return PLUGIN_HANDLED 
}

public plugin_init() { 
	register_plugin("AMX Public Restart Round Vote","1.0","SeSh") 
	register_menucmd(register_menuid("Restart round?") ,(1<<0)|(1<<1),"count_votes")
	register_clcmd("say voterr","voterr",0,"- starts a vote to restart round")
	register_cvar("amx_voterr_delay","60")
	register_cvar("amx_voterr_time","10")
	register_cvar("amx_voterr_ratio","0.60")
	register_cvar("amx_last_voting","0")
	set_cvar_float("amx_last_voting",0.0)
	new mod_name[32]
	get_modname(mod_name,31)
	cstrike = equal(mod_name,"cstrike") ? true : false
	return PLUGIN_CONTINUE 
}
